<?xml version='1.0'?>
<xsl:stylesheet>
<xsl:output method="html" indent="no"/>

<!-- 	Template to output a HTML radio button input element 
	for the movie prefs. This gives us a central place to store
	the button name and value strings. -->

<xsl:template name="moviePrefRadio">
	<xsl:param name="buttonName" />
	<xsl:param name="buttonValue" />
	<input type="radio">
		<xsl:attribute name="name">
			<xsl:value-of select="concat('moviePref', $buttonName)"/>
		</xsl:attribute>
		<xsl:attribute name="value">
			<xsl:value-of select="$buttonValue"/>
		</xsl:attribute>
	</input>
	
</xsl:template>


<xsl:template match="/">

<form>
<!--Start  blue border table w=597 --> 
<table width="597" border="0" cellspacing="0" cellpadding="2">
<tr valign="top" bgcolor="#B5D8E9"> 
	<td> <!--Start  white content table w=593 --> 
	<table width="593" border="0" cellspacing="0" cellpadding="0">
	<tr bgcolor="#FFFFFF"> 
		<td><!--Start Movie Prefs Table --> 
		<table width="593" border="0" cellspacing="0" cellpadding="4">
		<tr valign="top"> 
			<td colspan="2"><b><font size="3" color="#99CC33" face="Arial, Helvetica, sans-serif">Edit Movie Preferences:</font></b>
			</td>
		</tr>
		<tr>
			<td colspan="2" bgcolor="#B5D8E9"><font face="Arial, Helvetica, sans-serif" size="2"><b>Please rate the following movie genres:</b></font></td>
		</tr>
		<tr>
			<td>	
			<!--Start Genre Table--><p/>
			<table border="0" width="376">
			<tr> 
				<td><font color="#003399"><b><font face="Arial, Helvetica, sans-serif" size="2">Genre</font></b></font></td>
				<td align="middle"><font face="Arial, Helvetica, sans-serif" size="2">Strongly<br/>&#160;Dislike</font></td>
				<td align="middle"><font face="Arial, Helvetica, sans-serif" size="2">Dislike</font></td>
				<td align="middle"><font face="Arial, Helvetica, sans-serif" size="2">Somewhat <br/>&#160;Dislike</font></td>
				<td align="middle"><font face="Arial, Helvetica, sans-serif" size="2">Somewhat <br/>&#160;Like</font></td>
				<td align="middle"><font face="Arial, Helvetica, sans-serif" size="2">Like</font></td>
				<td align="middle"><font face="Arial, Helvetica, sans-serif" size="2">Strongly <br/>&#160;Like</font></td>
			</tr>
			<!-- Appply the following to each product category (movie genre)
			-->
			<xsl:for-each select="PRODUCT_CATEGORY/PRODUCT_CATEGORY">
			
			<tr> 
				<td><font face="Arial, Helvetica, sans-serif" size="2">
					<xsl:value-of select="PRODUCT_CATEGORY_DESC"/>
				</font></td>
				<td align="middle"> 
				<xsl:call-template name="moviePrefRadio">
					<xsl:with-param name="buttonName" select="child::PRODUCT_CATEGORY_ID"/>
					<xsl:with-param name="buttonValue" select="1"/>
				</xsl:call-template>
				</td>
				<td align="middle"> 
				<xsl:call-template name="moviePrefRadio">
					<xsl:with-param name="buttonName" select="child::PRODUCT_CATEGORY_ID"/>
					<xsl:with-param name="buttonValue" select="2"/>
				</xsl:call-template>
				</td>
				<td align="middle"> 
				<xsl:call-template name="moviePrefRadio">
					<xsl:with-param name="buttonName" select="child::PRODUCT_CATEGORY_ID"/>
					<xsl:with-param name="buttonValue" select="3"/>
				</xsl:call-template>
				</td>
				<td align="middle"> 
				<xsl:call-template name="moviePrefRadio">
					<xsl:with-param name="buttonName" select="child::PRODUCT_CATEGORY_ID"/>
					<xsl:with-param name="buttonValue" select="4"/>
				</xsl:call-template>
				</td>
				<td align="middle">
				<xsl:call-template name="moviePrefRadio">
					<xsl:with-param name="buttonName" select="child::PRODUCT_CATEGORY_ID"/>
					<xsl:with-param name="buttonValue" select="5"/>
				</xsl:call-template>
				</td>
				<td align="middle">
				<xsl:call-template name="moviePrefRadio">
					<xsl:with-param name="buttonName" select="child::PRODUCT_CATEGORY_ID"/>
					<xsl:with-param name="buttonValue" select="6"/>
				</xsl:call-template>
				</td>
			</tr>
			</xsl:for-each>

			</table>
			</td>
		</tr>
		</table>
			<!--End Movie Prefs Table -->
		</td>
	</tr>
	</table>
	<!--End  white content table w=593 --></td>
</tr>
</table>
</form>
<!--End  blue border table w=597 -->
</xsl:template>

</xsl:stylesheet>
